/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartGroundDeviceFake;
import minecrafttransportsimulator.items.instances.ItemPartGroundDevice;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPartGroundDevice;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class PartGroundDevice
extends APart {
    public static final Point3D groundDetectionOffset = new Point3D(0.0, -0.05f, 0.0);
    public static final Point3D groundOperationOffset = new Point3D(0.0, -0.25, 0.0);
    public static final String FLAT_VARIABLE = "isFlat";
    public final ComputedVariable flatVar;
    public boolean drivenLastTick = true;
    public boolean skipAngularCalcs = false;
    public double angularPosition;
    public double prevAngularPosition;
    public double angularVelocity;
    public final ComputedVariable motiveFrictionVar;
    public final ComputedVariable lateralFrictionVar;
    private final ComputedVariable heightVar;
    private double lastHeight;
    private final Point3D groundPosition = new Point3D();
    private ABlockBase.BlockMaterial blockMaterialBelow;
    private String blockNameBelow;
    public final Point3D wheelbasePoint;
    public boolean contactThisTick = false;
    public boolean animateAsOnGround;
    private int ticksCalcsSkipped = 0;
    private double prevAngularVelocity;
    private boolean prevActive = true;
    private final Point3D zeroReferencePosition;
    private final Point3D prevLocalOffset = this.localOffset.copy();
    public PartGroundDeviceFake fakePart;

    public PartGroundDevice(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartGroundDevice item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        this.zeroReferencePosition = this.position.copy();
        this.wheelbasePoint = placementDefinition.pos.copy().multiply(this.scale);
        AEntityF_Multipart<?> parent = entityOn;
        while (parent instanceof APart) {
            APart parentPart = (APart)parent;
            if (parentPart.placementDefinition.rot != null) {
                this.wheelbasePoint.rotate(parentPart.placementDefinition.rot);
            }
            this.wheelbasePoint.add(parentPart.placementDefinition.pos);
            parent = parentPart.entityOn;
        }
        this.flatVar = new ComputedVariable(this, FLAT_VARIABLE, data);
        this.addVariable(this.flatVar);
        this.motiveFrictionVar = new ComputedVariable(this, "motiveFriction");
        this.addVariable(this.motiveFrictionVar);
        this.lateralFrictionVar = new ComputedVariable(this, "lateralFriction");
        this.addVariable(this.lateralFrictionVar);
        this.heightVar = new ComputedVariable(this, "height");
        this.addVariable(this.heightVar);
    }

    @Override
    public void addPartsPostAddition(IWrapperPlayer placingPlayer, IWrapperNBT data) {
        super.addPartsPostAddition(placingPlayer, data);
        if (!this.isFake() && this.getLongPartOffset() != 0.0f && !this.isSpare) {
            JSONPartDefinition fakePlacementDef = JSONParser.duplicateJSON(this.placementDefinition);
            fakePlacementDef.pos.z += (double)this.getLongPartOffset();
            this.fakePart = new PartGroundDeviceFake(this, placingPlayer, fakePlacementDef, (ItemPartGroundDevice)this.getStack().getItem(), null);
            this.entityOn.addPart(this.fakePart, false);
        }
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater && (this.outOfHealth || damage.isExplosion || damage.damgeSource != null && Math.random() < 0.5)) {
            this.setFlatState(true);
        }
    }

    @Override
    public void update() {
        if (this.vehicleOn != null && !this.isSpare) {
            if (this.prevActive != this.isActive) {
                this.vehicleOn.groundDeviceCollective.updateMembers();
                this.vehicleOn.groundDeviceCollective.updateBounds();
                this.prevActive = this.isActive;
            }
            if (!this.localOffset.equals(this.prevLocalOffset)) {
                this.vehicleOn.groundDeviceCollective.updateBounds();
                this.prevLocalOffset.set(this.localOffset);
            }
            if (this.lastHeight != this.heightVar.currentValue) {
                this.vehicleOn.groundDeviceCollective.updateBounds();
                this.boundingBox.heightRadius = this.heightVar.currentValue;
            }
            this.zeroReferencePosition.set(this.placementDefinition.pos).rotate(this.entityOn.orientation).add(this.entityOn.position);
            if (this.vehicleOn.groundDeviceCollective.groundedGroundDevices.contains(this)) {
                this.animateAsOnGround = true;
                if (!this.skipAngularCalcs) {
                    this.prevAngularVelocity = this.angularVelocity;
                    this.angularVelocity = this.getDesiredAngularVelocity();
                }
                if (((JSONPart)this.definition).ground.isWheel) {
                    Point3D blockPositionBelow;
                    this.contactThisTick = false;
                    if (Math.abs(this.prevAngularVelocity) / (this.vehicleOn.groundVelocity / (this.getHeight() * Math.PI)) < 0.25 && this.vehicleOn.velocity > 0.3 && !this.world.isAir(blockPositionBelow = this.position.copy().add(0.0, -1.0, 0.0)) && (double)this.world.getBlockHardness(blockPositionBelow) >= 1.25) {
                        this.contactThisTick = true;
                    }
                    if (!this.vehicleOn.world.isClient() && !this.flatVar.isActive) {
                        if (!this.skipAngularCalcs) {
                            if (this.ticksCalcsSkipped > 0) {
                                --this.ticksCalcsSkipped;
                            }
                        } else {
                            ++this.ticksCalcsSkipped;
                            if (Math.random() * 50000.0 < (double)this.ticksCalcsSkipped) {
                                this.setFlatState(true);
                            }
                        }
                    }
                }
                if (!this.vehicleOn.world.isClient() && this.vehicleOn.velocity >= (Double)ConfigSystem.settings.damage.wheelDamageMinimumVelocity.value) {
                    this.boundingBox.widthRadius += 0.25;
                    this.boundingBox.depthRadius += 0.25;
                    double wheelDamageAmount = (Boolean)ConfigSystem.settings.damage.wheelDamageIgnoreVelocity.value == false ? (Double)ConfigSystem.settings.damage.wheelDamageFactor.value * this.vehicleOn.velocity * this.vehicleOn.currentMass / 1000.0 : (Double)ConfigSystem.settings.damage.wheelDamageFactor.value * this.vehicleOn.currentMass / 1000.0;
                    IWrapperEntity controller = this.vehicleOn.getController();
                    LanguageSystem.LanguageEntry language = controller != null ? LanguageSystem.DEATH_WHEEL_PLAYER : LanguageSystem.DEATH_WHEEL_NULL;
                    Damage wheelDamage = new Damage(wheelDamageAmount, this.boundingBox, this, controller, language);
                    this.vehicleOn.world.attackEntities(wheelDamage, null, false);
                    this.boundingBox.widthRadius -= 0.25;
                    this.boundingBox.depthRadius -= 0.25;
                }
                this.groundPosition.set(this.position);
                this.groundPosition.y -= this.getHeight() / 2.0;
                double yPositionFraction = this.groundPosition.y % 1.0;
                this.groundPosition.y = 1.0 - yPositionFraction < -PartGroundDevice.groundDetectionOffset.y ? Math.ceil(this.groundPosition.y) - 1.0 : Math.floor(this.groundPosition.y) - 1.0;
                this.blockNameBelow = this.world.getBlockName(this.groundPosition);
                this.blockMaterialBelow = this.world.getBlockMaterial(this.groundPosition);
            } else {
                if (!this.drivenLastTick) {
                    if (this.vehicleOn.brakeVar.isActive || this.vehicleOn.parkingBrakeVar.isActive) {
                        this.angularVelocity = 0.0;
                    } else if (this.angularVelocity > 0.0) {
                        this.angularVelocity = (float)Math.max(this.angularVelocity - 0.05, 0.0);
                    }
                } else {
                    this.drivenLastTick = false;
                }
                if (this.animateAsOnGround && !this.vehicleOn.groundDeviceCollective.isActuallyOnGround(this)) {
                    this.animateAsOnGround = false;
                }
                this.blockNameBelow = null;
                this.blockMaterialBelow = null;
            }
            this.prevAngularPosition = this.angularPosition;
            this.angularPosition = this.isMirrored && !((JSONPart)this.definition).ground.isTread ? (this.angularPosition -= this.angularVelocity) : (this.angularPosition += this.angularVelocity);
        }
        super.update();
    }

    @Override
    public void setVariableDefaults() {
        super.setVariableDefaults();
        float frictionLoss = this.getFrictionLoss();
        double currentMotiveFriction = ((JSONPart)this.definition).ground.motiveFriction - frictionLoss;
        double currentLateralFriction = ((JSONPart)this.definition).ground.lateralFriction - frictionLoss;
        if (this.flatVar.isActive) {
            currentMotiveFriction /= 10.0;
            currentLateralFriction /= 10.0;
        }
        if (currentMotiveFriction < 0.0) {
            currentMotiveFriction = 0.0;
        }
        if (currentLateralFriction < 0.0) {
            currentLateralFriction = 0.0;
        }
        this.motiveFrictionVar.setTo(currentMotiveFriction, false);
        this.lateralFrictionVar.setTo(currentLateralFriction, false);
        this.lastHeight = this.heightVar.currentValue;
        this.heightVar.setTo((double)(this.flatVar.isActive ? ((JSONPart)this.definition).ground.flatHeight : ((JSONPart)this.definition).ground.height) * this.scale.y, false);
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "ground_rotation": {
                return new ComputedVariable(this, variable, partialTicks -> this.vehicleOn != null ? this.vehicleOn.speedFactor * (partialTicks != 0.0f ? this.prevAngularPosition + (this.angularPosition - this.prevAngularPosition) * (double)partialTicks : this.angularPosition) * 360.0 : 0.0, true);
            }
            case "ground_rotation_normalized": {
                return new ComputedVariable(this, variable, partialTicks -> this.vehicleOn != null ? (double)Math.floorMod(Math.round(this.vehicleOn.speedFactor * (this.prevAngularPosition + (this.angularPosition - this.prevAngularPosition) * (double)partialTicks) * 3600.0), 3600L) / 10.0 : 0.0, true);
            }
            case "ground_onground": {
                return new ComputedVariable(this, variable, partialTicks -> this.vehicleOn != null && this.animateAsOnGround ? 1.0 : 0.0, false);
            }
            case "ground_isflat": {
                return this.flatVar;
            }
            case "ground_contacted": {
                return new ComputedVariable(this, variable, partialTicks -> this.contactThisTick ? 1.0 : 0.0, false);
            }
            case "ground_skidding": {
                return new ComputedVariable(this, variable, partialTicks -> this.skipAngularCalcs ? 1.0 : 0.0, false);
            }
            case "ground_slipping": {
                return new ComputedVariable(this, variable, partialTicks -> this.vehicleOn != null && this.vehicleOn.slipping && this.animateAsOnGround ? 1.0 : 0.0, false);
            }
            case "ground_distance": {
                return new ComputedVariable(this, variable, partialTicks -> this.world.getHeight(this.zeroReferencePosition), false);
            }
        }
        if (variable.startsWith("ground_blockname")) {
            String blockName = variable.substring("ground_blockname_".length()).toLowerCase();
            return new ComputedVariable(this, variable, partialTicks -> this.blockNameBelow != null && this.blockNameBelow.equals(blockName) ? 1.0 : 0.0, false);
        }
        if (variable.startsWith("ground_blockmaterial")) {
            String materialName = variable.substring("ground_blockmaterial_".length()).toUpperCase();
            return new ComputedVariable(this, variable, partialTicks -> this.blockMaterialBelow != null && this.blockMaterialBelow.name().equals(materialName) ? 1.0 : 0.0, false);
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public double getWidth() {
        return (double)((JSONPart)this.definition).ground.width * this.scale.x;
    }

    @Override
    public double getHeight() {
        return this.heightVar.currentValue;
    }

    public void setFlatState(boolean setFlat) {
        if (!this.world.isClient()) {
            if (setFlat ? this.flatVar.isActive || ((JSONPart)this.definition).ground.flatHeight == 0.0f || (Boolean)ConfigSystem.settings.damage.wheelBreakage.value == false : !this.flatVar.isActive) {
                return;
            }
            InterfaceManager.packetInterface.sendToAllClients(new PacketPartGroundDevice(this, setFlat));
        }
        this.flatVar.setActive(setFlat, false);
    }

    public double getDesiredAngularVelocity() {
        if (this.vehicleOn != null && (((JSONPart)this.definition).ground.isWheel || ((JSONPart)this.definition).ground.isTread)) {
            if (this.vehicleOn.skidSteerActive) {
                if (this.placementDefinition.pos.x > 0.0) {
                    return this.getLongPartOffset() == 0.0f ? this.vehicleOn.rudderAngleVar.currentValue / 200.0 / (this.getHeight() * Math.PI) : this.vehicleOn.rudderAngleVar.currentValue / 200.0;
                }
                if (this.placementDefinition.pos.x < 0.0) {
                    return this.getLongPartOffset() == 0.0f ? -this.vehicleOn.rudderAngleVar.currentValue / 200.0 / (this.getHeight() * Math.PI) : -this.vehicleOn.rudderAngleVar.currentValue / 200.0;
                }
                return 0.0;
            }
            if (this.vehicleOn.goingInReverse) {
                return this.getLongPartOffset() == 0.0f ? -this.vehicleOn.groundVelocity / (this.getHeight() * Math.PI) : -this.vehicleOn.groundVelocity;
            }
            return this.getLongPartOffset() == 0.0f ? this.vehicleOn.groundVelocity / (this.getHeight() * Math.PI) : this.vehicleOn.groundVelocity;
        }
        return 0.0;
    }

    private float getFrictionLoss() {
        if (!this.world.isAir(this.groundPosition)) {
            float penalty = this.world.getBlockSlipperiness(this.groundPosition) - 0.6f;
            Float modifier = ((JSONPart)this.definition).ground.frictionModifiers.get((Object)this.blockMaterialBelow);
            if (modifier != null) {
                penalty -= modifier.floatValue();
            }
            this.groundPosition.y += 1.0;
            if (this.world.getRainStrength(this.groundPosition) > 0.0f) {
                penalty += ((JSONPart)this.definition).ground.wetFrictionPenalty;
            }
            this.groundPosition.y -= 1.0;
            return penalty;
        }
        return 0.0f;
    }

    public float getLongPartOffset() {
        return this.placementDefinition.extraCollisionBoxOffset != 0.0f ? this.placementDefinition.extraCollisionBoxOffset : ((JSONPart)this.definition).ground.extraCollisionBoxOffset;
    }
}

